/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.peer.FramePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class Frame
extends Window
implements MenuContainer {
    public static final int DEFAULT_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    String title = "Untitled";
    Image icon;
    MenuBar menuBar;
    boolean resizable = true;
    boolean mbManagement = false;
    Vector ownedWindows;
    private static final String base = "frame";
    private static int nameCounter;
    private static final long serialVersionUID = 2673458971256075116L;
    private int frameSerializedDataVersion = 1;

    public Frame() {
        this("");
    }

    public Frame(String string) {
        this.name = base + nameCounter++;
        this.title = string;
        this.visible = false;
        this.setLayout(new BorderLayout());
    }

    Window addOwnedWindow(Window window) {
        if (window != null) {
            if (this.ownedWindows == null) {
                this.ownedWindows = new Vector();
            }
            this.ownedWindows.addElement(window);
        }
        return window;
    }

    void removeOwnedWindow(Window window) {
        if (window != null && this.ownedWindows != null) {
            this.ownedWindows.removeElement(window);
        }
    }

    public void addNotify() {
        this.peer = this.getToolkit().createFrame(this);
        MenuBar menuBar = this.menuBar;
        if (menuBar != null) {
            menuBar.addNotify();
            ((FramePeer)this.peer).setMenuBar(menuBar);
        }
        super.addNotify();
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String string) {
        this.title = string;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            framePeer.setTitle(string);
        }
    }

    public Image getIconImage() {
        return this.icon;
    }

    public synchronized void setIconImage(Image image) {
        this.icon = image;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            framePeer.setIconImage(image);
        }
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public synchronized void setMenuBar(MenuBar menuBar) {
        if (this.menuBar == menuBar) {
            return;
        }
        if (menuBar != null && menuBar.parent != null) {
            menuBar.parent.remove(menuBar);
        }
        if (this.menuBar != null) {
            this.remove(this.menuBar);
        }
        this.menuBar = menuBar;
        if (this.menuBar != null) {
            this.menuBar.parent = this;
            FramePeer framePeer = (FramePeer)this.peer;
            if (framePeer != null) {
                this.mbManagement = true;
                this.menuBar.addNotify();
                framePeer.setMenuBar(this.menuBar);
            }
        }
        this.invalidate();
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public synchronized void setResizable(boolean bl) {
        this.resizable = bl;
        FramePeer framePeer = (FramePeer)this.peer;
        if (framePeer != null) {
            framePeer.setResizable(bl);
        }
    }

    public synchronized void remove(MenuComponent menuComponent) {
        if (menuComponent == this.menuBar) {
            FramePeer framePeer = (FramePeer)this.peer;
            if (framePeer != null) {
                this.mbManagement = true;
                this.menuBar.removeNotify();
                this.menuBar.parent = null;
                framePeer.setMenuBar(null);
            }
            this.menuBar = null;
            return;
        }
        super.remove(menuComponent);
    }

    public void dispose() {
        Object object = Component.LOCK;
        synchronized (object) {
            if (this.ownedWindows != null) {
                int n = this.ownedWindows.size();
                Object[] objectArray = new Window[n];
                this.ownedWindows.copyInto(objectArray);
                int n2 = 0;
                while (n2 < n) {
                    ((Window)objectArray[n2]).dispose();
                    ++n2;
                }
            }
            if (this.menuBar != null) {
                this.remove(this.menuBar);
                this.menuBar = null;
            }
        }
        super.dispose();
    }

    void postProcessKeyEvent(KeyEvent keyEvent) {
        if (this.menuBar != null && this.menuBar.handleShortcut(keyEvent)) {
            keyEvent.consume();
            return;
        }
        super.postProcessKeyEvent(keyEvent);
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.resizable) {
            string = String.valueOf(string) + ",resizable";
        }
        if (this.title != null) {
            string = String.valueOf(string) + ",title=" + this.title;
        }
        return string;
    }

    public synchronized void setCursor(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        this.setCursor(Cursor.getPredefinedCursor(n));
    }

    public int getCursorType() {
        return this.getCursor().getType();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.menuBar != null) {
            this.menuBar.parent = this;
        }
        if (this.ownedWindows != null) {
            int n = 0;
            while (n < this.ownedWindows.size()) {
                Window window = (Window)this.ownedWindows.elementAt(n);
                window.parent = this;
                ++n;
            }
        }
    }
}

